from django.db.models.signals import post_save
from django.dispatch import receiver, Signal

from intranet.femida.src.vacancies.choices import ACTIVE_VACANCY_STATUSES
from intranet.femida.src.vacancies.models import Vacancy
from intranet.femida.src.vacancies.tasks import create_vacancy_edit_issue_task


vacancy_approved = Signal(providing_args=['vacancy'])
vacancy_unapproved = Signal(providing_args=['vacancy'])


@receiver(post_save, sender=Vacancy)
def check_unused_submission_forms(sender, instance, **kwargs):
    is_not_active_anymore = (
        instance._initial['status'] in ACTIVE_VACANCY_STATUSES
        and instance.status not in ACTIVE_VACANCY_STATUSES
    )

    if is_not_active_anymore:
        unused_submission_forms = list(
            instance.submission_forms
            .exclude(
                id__in=(
                    instance.submission_forms
                    .filter(vacancies__status__in=ACTIVE_VACANCY_STATUSES._db_values)
                ),
            )
        )
        for submission_form in unused_submission_forms:
            create_vacancy_edit_issue_task.delay(instance.id, submission_form.id)
