import logging

from intranet.femida.src.core.workflow import Workflow, Action
from intranet.femida.src.vacancies.controllers import update_or_create_vacancy_group


logger = logging.getLogger(__name__)


class UpdateAction(Action):

    def has_permission(self):
        return self.user.is_recruiter

    def perform(self, **params):
        instance = update_or_create_vacancy_group(params, self.user, self.instance)
        return instance


class ActivateAction(Action):

    def has_permission(self):
        return self.user.is_recruiter and not self.instance.is_active

    def perform(self, **params):
        self.instance.is_active = True
        self.instance.save()

        return self.instance


class DeactivateAction(Action):

    def has_permission(self):
        return self.user.is_recruiter and self.instance.is_active

    def perform(self, **params):
        self.instance.is_active = False
        self.instance.save()

        return self.instance


class VacancyGroupWorkflow(Workflow):

    ACTION_MAP = {
        'update': UpdateAction,
        'activate': ActivateAction,
        'deactivate': DeactivateAction,
    }
