from django.db.models import Q

from intranet.femida.src.permissions.helpers import get_manager


def get_broken_instances_qs(model):
    """
    Если поле с wiki-разметкой непустое, а отформатированное поле пустое, то считаем, что
    форматирование прошло с ошибкой.
    """
    manager = get_manager(model, unsafe=True)
    query = Q()
    for field_name, wiki_field_name in model.WIKI_FIELDS_MAP.items():
        query |= (
            ~Q(**{field_name: ''})
            & Q(**{wiki_field_name: ''})
        )
    return manager.filter(query)
