import logging

from django.apps import apps

from intranet.femida.src.permissions.helpers import get_manager
from intranet.femida.src.celery_app import app
from intranet.femida.src.utils.lock import locked_task
from intranet.femida.src.wf.helpers import get_broken_instances_qs


logger = logging.getLogger(__name__)


@app.task
@locked_task
def wiki_reformat_broken_instances():
    from intranet.femida.src.wf.models import WFModelMixin

    wiki_models = [m for m in apps.get_models() if issubclass(m, WFModelMixin)]
    for model in wiki_models:
        queryset = get_broken_instances_qs(model)
        total_count = queryset.count()
        success_count = 0
        logger.info('Start reformatting %d %s instances', total_count, queryset.model.__name__)

        for instance in queryset:
            is_ok = instance.format_wiki_fields(
                force=True,
                timeout=15,
                save=True,
            )
            if is_ok:
                success_count += 1

        logger.info(
            '%d of %d %s instances was reformatted',
            success_count, total_count, queryset.model.__name__
        )


@app.task
def wiki_reformat_instance(instance_id, **kwargs):
    # TODO: kwargs используется для обратной совместимости
    # переделать на нормальный вариант после релиза FEMIDA-3217
    app_label = kwargs.get('app_label')
    model_name = kwargs.get('model_name')
    model = kwargs.get('model') or apps.get_model(app_label, model_name)

    manager = get_manager(model, unsafe=True)
    instance = manager.get(id=instance_id)
    instance.format_wiki_fields(force=True, timeout=15, save=True)
