PY3_LIBRARY(femida)

OWNER(g:tools-femida)

PEERDIR(
    contrib/python/boto3
    contrib/python/celery/py2
    contrib/python/dateutil
    contrib/python/django/django-2.2
    contrib/python/django-constance
    contrib/python/django-cors-headers
    contrib/python/django-model-utils/py2
    contrib/python/django-picklefield
    contrib/python/django-redis
    contrib/python/django-replicated
    contrib/python/django-storages
    contrib/python/django-waffle
    contrib/python/djangorestframework
    contrib/python/django-extensions
    contrib/python/djangorestframework-csv
    contrib/python/django-export-action-py3
    contrib/python/drf-yasg
    contrib/python/ipdb
    contrib/python/ipython
    contrib/python/openpyxl
    contrib/python/phonenumbers
    contrib/python/premailer
    contrib/python/psycopg2
    contrib/python/Pygments
    contrib/python/pymongo
    contrib/python/pyOpenSSL
    contrib/python/pytz
    contrib/python/PyYAML
    contrib/python/regex
    contrib/python/requests
    contrib/python/uwsgi
    contrib/python/xlrd
    contrib/python/xlwt
    contrib/python/zero-downtime-migrations
    
    library/python/blackbox
    library/python/datasources-config-wrapper
    library/python/django
    library/python/django-idm-api
    library/python/django-sform
    library/python/django_celery_monitoring
    library/python/django_mds
    library/python/django_pgaas
    library/python/django_tools_log_context
    library/python/granular_settings
    library/python/ids
    library/python/python-django-yauth
    library/python/startrek_python_client
    library/python/statface_client
    library/python/yenv
    library/python/ylock
    library/python/ylog

    maps/doc/proto/yandex/maps/proto/common2
    maps/doc/proto/yandex/maps/proto/search
    maps/doc/proto/yandex/maps/proto/uri

    yt/python/client
)

PY_SRCS(
    __init__.py
    apps.py
    celery_app.py
    local_settings.py
    mail_settings.py
    makemigrations_settings.py
    manage.py
    settings.py
    tasks.py
    urls.py
)

RESOURCE_FILES(
    PREFIX intranet/femida/src/

    settings/000-debug.conf
    settings/000-debug.conf.development
    settings/001-site.conf
    settings/001-site.conf.development
    settings/001-site.conf.testing
    settings/001-site.conf.testing.beamery_uat
    settings/002-site.conf
    settings/010-datasources.conf
    settings/020-paths.conf
    settings/020-paths.conf.development
    settings/030-security.conf
    settings/030-security.conf.development
    settings/040-apps.conf
    settings/040-apps.conf.development
    settings/050-databases.conf
    settings/050-databases.conf.development
    settings/060-middleware.conf
    settings/070-templates.conf
    settings/073-mongo.conf
    settings/073-mongo.conf.production
    settings/074-beamery.conf
    settings/075-celery.conf
    settings/075-celery.conf.testing.beamery_uat
    settings/083-yt.conf
    settings/085-ylock.conf
    settings/090-email.conf
    settings/090-email.conf.production
    settings/091-email.conf
    settings/095-cache.conf
    settings/095-cache.conf.development
    settings/100-passport.conf
    settings/100-passport.conf.production
    settings/110-blackbox.conf
    settings/120-logging.conf
    settings/120-logging.conf.development
    settings/130-yauth.conf
    settings/130-yauth.conf.production
    settings/131-yauth.conf
    settings/135-isearch.conf
    settings/135-isearch.conf.production
    settings/136-isearch.conf
    settings/140-restframework.conf
    settings/140-restframework.conf.development
    settings/141-swagger.conf
    settings/142-startrek.conf
    settings/142-startrek.conf.production
    settings/143-startrek.conf
    settings/145-staff.conf
    settings/145-staff.conf.production
    settings/146-isearch-front.conf
    settings/146-isearch-front.conf.production
    settings/150-idm.conf
    settings/150-idm.conf.production
    settings/153-wiki.conf
    settings/153-wiki.conf.production
    settings/154-jing.conf
    settings/154-jing.conf.production
    settings/155-calendar.conf
    settings/155-calendar.conf.production
    settings/156-calendar.conf
    settings/160-oebs.conf
    settings/160-oebs.conf.production
    settings/165-mds.conf
    settings/165-mds.conf.production
    settings/170-constance.conf
    settings/170-constance.conf.development
    settings/175-offer.conf
    settings/180-abc.conf
    settings/180-abc.conf.production
    settings/185-docviewer.conf
    settings/185-docviewer.conf.production
    settings/190-forms.conf
    settings/190-forms.conf.production
    settings/210-tikaite.conf
    settings/210-tikaite.conf.production
    settings/220-hh.conf
    settings/225-amazing_hiring.conf
    settings/230-contest.conf
    settings/230-contest.conf.production
    settings/250-femida.conf
    settings/260-at.conf
    settings/260-at.conf.production
    settings/270-ok.conf
    settings/270-ok.conf.production
    settings/280-bunker.conf
    settings/280-bunker.conf.production
    settings/290-cabinet.conf
    settings/300-magiclinks.conf
    settings/310-aa.conf
    settings/320-hrdb.conf
    settings/320-hrdb.conf.production
    settings/330-table-flow.conf
    settings/330-table-flow.conf.production
    settings/340-jobs.conf
    settings/340-jobs.conf.production
    settings/345-begemot.conf
    settings/345-begemot.conf.production
    settings/350-s3.conf
    settings/360-vanadium.conf
    settings/370-geosearch.conf
    settings/370-geosearch.conf.production
    settings/371-geosuggest.conf
    settings/371-geosuggest.conf.production
)

END()
