import yt.wrapper as yt


# porto-слой с ubuntu bionic (18.04), который мы сами используем на серверах
# https://yt.yandex-team.ru/docs/description/mr/porto/layer_paths.html
bionic_layer = '//porto_layers/base/bionic/porto_layer_search_ubuntu_bionic_app_lastest.tar.gz'

layer_paths = [bionic_layer]
spec = {
    'mapper': {
        'layer_paths': layer_paths,
    },
}


def get_rows_by_yandexuids(input_table, yandexuids, yson_encoding='utf-8'):
    yt_format = yt.YsonFormat(encoding=yson_encoding)

    # Note: если для yson задать кодировку None,
    # то всё становится байтовым. В т.ч. и названия колонок
    yandexuid_key = b'yandexuid' if yson_encoding is None else 'yandexuid'

    def mapper(row):
        if row.get(yandexuid_key) in yandexuids:
            yield row

    with yt.TempTable('//home/femida') as output_table:
        yt.run_map(
            binary=mapper,
            source_table=input_table,
            destination_table=output_table,
            spec=spec,
            format=yt_format,
        )
        result = list(yt.read_table(output_table, format=yt_format))

    return result
