import datetime
import logging

from intranet.femida.src.yt.management.commands.base import SubmissionsYtJobCommand

from intranet.femida.src.notifications.candidates import SubmissionSeoCheckNotification

import yt.wrapper as yt


logger = logging.getLogger(__name__)


def two_largest(collection):
    m1 = m2 = '0000-00-00'
    for x in collection:
        if x > m2:
            if x >= m1:
                m1, m2 = x, m1
            else:
                m2 = x
    return m1, m2


class Command(SubmissionsYtJobCommand):

    help = 'SEO check candidate by submission_id'
    command_code = 'SEO_CHECK'

    def get_input_table(self):
        """
        Get last available day, but not today
        """
        tables = yt.get('//statbox/crypta-yandexuid-profiles-log')
        input_table_path = '//statbox/crypta-yandexuid-profiles-log/'

        m1, m2 = two_largest(tables.keys())
        today = datetime.date.today().strftime('%Y-%m-%d')
        day_str = m2 if m1 == today else m1

        input_table = input_table_path + day_str
        logger.info('Input table for seo_check is %s', input_table)
        return input_table

    def process_rows(self, rows):
        SEO_KEY = '208'
        count = 0
        for row in rows:
            marketing_segments = row.get('marketing_segments') or {}
            probability = marketing_segments.get(SEO_KEY)
            if probability is not None:
                for submission in self.uid_submissions_map.get(row['yandexuid'], []):
                    notification = SubmissionSeoCheckNotification(
                        instance=submission,
                        probability=probability,
                    )
                    notification.send()
                    count += 1
        logger.info('[%s] %d emails about seo check were sent', self.command_code, count)
