# flake8: noqa


text = """{% load pluralizations %}
{{ org }} (далее – Компания) предлагает Вам должность "{{ offer.position.name_ru }}" в подразделении "{{ offer.department.name }}".
{% if offer.work_place == 'office' %}
Вашим непосредственным руководителем будет {{ offer.boss.get_full_name }}.
{% endif %}

{% if offer.is_main_work_place %}
{% if offer.employment_type == 'full' %}
Работа предполагает полную занятость и будет являться основным местом работы.
{% elif offer.employment_type == 'partial' %}
Работа предполагает неполную занятость{% if offer.work_place == 'office' %} ({{ offer.work_hours_weekly }} {% get_russian_plural_form offer.work_hours_weekly "час" "часа" "часов" %} в неделю){% endif %} и будет являться основным местом работы.
{% endif %}
{% elif offer.employment_type == 'partial' %}
Работа предполагает неполную занятость{% if offer.work_place == 'office' %} ({{ offer.work_hours_weekly }} {% get_russian_plural_form offer.work_hours_weekly "час" "часа" "часов" %} в неделю){% endif %} и будет являться работой по совместительству.
{% endif %}

{% if offer.work_place == 'office' %}
Местом работы будет офис Компании, расположенный в городе {{ offer.office.city.name_ru }}.
{% elif offer.work_place == 'home' %}
Вы будете выполнять работу дистанционно.
{% endif %}

Дата выхода на работу – {{ offer.join_at|date:"d.m.Y" }}.

{# Срок договора #}
{% if offer.contract_type == 'temp_replacement' %}
С Вами будет заключен срочный трудовой договор на время исполнения обязанностей отсутствующего работника.
{% elif offer.contract_type == 'fixed_term_date' and offer.contract_term_date %}
С Вами будет заключен срочный трудовой договор на срок по {{ offer.contract_term_date|date:"d.m.Y" }} (включительно).
{% elif offer.contract_type == 'project' %}
В связи с тем, что Ваша работа будет носить заведомо временный характер, трудовой договор с Вами будет заключен на период до завершения работы над проектом.
{% elif offer.contract_type == 'fixed_term' %}
С Вами будет заключен срочный трудовой договор на {{ offer.contract_term }} {% get_russian_plural_form offer.contract_term "месяц" "месяца" "месяцев" %} с даты принятия на работу (включительно).
{% endif %}

{# Испытательный срок #}
{% if offer.probation_period %}
{% if offer.probation_period_unit == 'month' %}
Испытательный срок составит {{ offer.probation_period }} {% get_russian_plural_form offer.probation_period "месяц" "месяца" "месяцев" %}.
{% elif offer.probation_period_unit == 'week' %}
Испытательный срок составит {{ offer.probation_period }} {% get_russian_plural_form offer.probation_period "неделю" "недели" "недель" %}.
{% endif %}
{% else %}
Вы будете приняты на работу без испытательного срока.
{% endif %}

{# Оплата труда #}
{% if offer.payment_type == 'monthly' %}
Компания предлагает Вам должностной оклад в размере {{ offer.salary|floatformat:-2 }} {{ currency.code }} (из указанной суммы будет удерживаться НДФЛ согласно законодательству РФ).

Помимо должностного оклада Вам может, в соответствии с политиками Компании, выплачиваться премия.
{% elif offer.payment_type == 'piecework' %}
Вам будет установлена сдельно-премиальная система оплаты труда. Ваша заработная плата будет исчисляться, исходя из сдельных расценок, установленных в Компании, и количества задач, которые Вы выполните за месяц. Сдельные расценки на задачи, выполняемые Вами, устанавливаются локальным нормативным актом Компании. Из суммы заработной платы, будет удерживаться НДФЛ согласно законодательству РФ.

Вам также может, в соответствии с политиками Компании, выплачиваться премия.
{% elif offer.payment_type == 'hourly' %}
Вам будет установлена почасовая оплата труда. Компания предлагает Вам часовую тарифную ставку в размере {{ offer.hourly_rate|floatformat:-2 }} {{ currency.code }}. Ваша заработная плата будет исчисляться, исходя из часовой тарифной ставки и количества отработанных Вами часов в месяц. Из суммы заработной платы, будет удерживаться НДФЛ согласно законодательству РФ.

Вам также может, в соответствии с политиками Компании, выплачиваться премия.
{% endif %}

{% if offer.rsu_cost %}
Вам также будет предоставлено право на участие в программе премирования сотрудников акциями компании Yandex N.V. В рамках указанной программы Вам будет выдан грант общей величиной  {{ offer.rsu_cost|floatformat:-2 }} долларов США. В дату выхода на работу указанный грант будет пересчитан в определенное целое количество RSU (рассчитанное в соответствии с математическими правилами округления), исходя из средней цены закрытия акций Компании за полный календарный месяц, предшествующий месяцу начала Вашей работы в Компании. Данный пакет RSU может быть реализован, в соответствии с общими условиями опционного плана, действующего на момент выдачи (с последующими изменениями). При этом началом периода вестинга будет являться первый день месяца, следующего за месяцем Вашего выхода на работу. Из предоставленных Вам RSU право реализации 1/4 (одной четверти) возникнет по истечении одного календарного года после начала периода вестинга, далее вестинг будет происходить каждые три месяца равными долями по 1/16 (одной шестнадцатой) от всех выданных Вам RSU. Полный цикл вестинга – 4 года.

Вестинг – это процедура постепенного получения права реализации предоставленных RSU по мере истечения определенного периода времени работы в Компании. Вы можете распоряжаться RSU, срок реализации которых наступил, как частично, так и одним пакетом в течение 10 лет с момента выдачи RSU.
{% endif %}

{% if offer.rsu and not offer.rsu_cost %}
Вам также будет предоставлено право на участие в программе премирования сотрудников акциями Компании Yandex N.V. в количестве {{ offer.rsu }} RSU, которое может быть реализовано в соответствии с общими условиями опционного плана, действующего на момент выдачи RSU. При этом началом периода вестинга будет являться первый день месяца, следующего за месяцем Вашего выхода на работу. Из предоставленных Вам RSU 1/4 завестится через год после начала периода вестинга, далее вестинг будет происходить каждые 3 месяца равными долями по 1/16 от всех выданных Вам RSU. Полный цикл вестинга – 4 года.

Вестинг – это процедура постепенного получения права распоряжаться предоставленными RSU по мере истечения определенного срока работы в Компании. Вы можете распоряжаться завестившимися акциями как частями по наступлению вестинга, так и одним пакетом в течение 10 лет с момента выдачи RSU.
{% endif %}

{% if offer.signup_bonus and offer.allowance %}
В течение 30 дней с даты выхода на работу Компания сделает Вам единовременную выплату, предоставив беспроцентный заём в размере {{ offer.total_start_bonus|floatformat:-2 }} {{ currency.code }} (в том числе {{ offer.allowance|floatformat:-2 }} {{ currency.code }} по корпоративной программе релокации сотрудников) сроком пользования 1 год с даты начала работы в Компании. По истечении года работы в Компании Вы будете освобождены от лежащей на Вас обязанности по возврату суммы займа. В случае прекращения трудовых отношений по любой причине в течение первого года работы Вы будете обязаны полностью вернуть сумму займа.
{% elif offer.signup_bonus or offer.allowance %}
В течение 30 дней с даты выхода на работу Компания сделает Вам единовременную выплату, предоставив беспроцентный заём в размере {{ offer.total_start_bonus|floatformat:-2 }} {{ currency.code }} сроком пользования 1 год с даты начала работы в Компании. По истечении года работы в Компании Вы будете освобождены от лежащей на Вас обязанности по возврату суммы займа. В случае прекращения трудовых отношений по любой причине в течение первого года работы Вы будете обязаны полностью вернуть сумму займа.
{% endif %}
{% if offer.signup_2year_bonus %}
После истечения года работы Компания сделает Вам вторую единовременную выплату, предоставив беспроцентный заём в размере {{ offer.signup_2year_bonus|floatformat:-2 }} {{ currency.code }} сроком пользования 1 год с даты начала второго года работы в Компании. По истечении второго года работы в Компании Вы будете освобождены от лежащей на Вас обязанности по возврату суммы займа. В случае прекращения трудовых отношений по любой причине в течение второго года работы Вы будете обязаны полностью вернуть сумму второго займа.
{% endif %}

{% if offer.welcome_bonus_gross %}
Также Компания предоставляет Вам премию при приеме на работу в размере {{ offer.welcome_bonus_gross|floatformat:-2 }} {{ currency.code }} (из указанной суммы будет удерживаться НДФЛ согласно законодательству РФ), которая будет выплачиваться в соответствии со следующим графиком:

50% от суммы премии через 6 месяцев с даты выхода на работу в Компанию;
25% от суммы премии через 9 месяцев с даты выхода на работу в Компанию;
оставшиеся 25% от суммы премии через 12 месяцев с даты выхода на работу в Компанию.
{% endif %}

{% if offer.signup_bonus_gross %}
В течение 30 дней с даты выхода на работу Компания сделает Вам единовременную выплату, предоставив беспроцентный заём в размере {{ offer.signup_bonus_gross|floatformat:-2 }} {{ currency.code }} сроком пользования 1 год с даты начала работы в Компании. По истечении года работы в Компании Вы будете освобождены от лежащей на Вас обязанности по возврату суммы займа. В случае прекращения трудовых отношений по любой причине в течение первого года работы Вы будете обязаны полностью вернуть сумму займа.
{% endif %}

{% if offer.need_relocation %}
В соответствии с корпоративной программой релокации сотрудников Компания готова организовать для Вас возможность получения комплекса услуг, связанных с Вашим переездом к месту работы, через специализированную компанию по выбору и на усмотрение Компании, а также оплатит за Вас выбранные услуги по факту их оказания. Перечень услуг специализированной компании, которыми Вы сможете воспользоваться, согласовывается с менеджером по релокации.
{% if offer.signup_bonus or offer.allowance %}
Компания помимо основной суммы займа, указанной выше, выплатит Вам дополнительную сумму займа, на аналогичных условиях использования. Размер такой дополнительной суммы займа будет определен исходя из стоимости фактически оказанных Вам специализированной компанией услуг.
{% else %}
В течение 30 дней с даты выхода на работу Компания сделает Вам единовременную выплату, предоставив беспроцентный заём. Размер суммы займа будет определен исходя из стоимости фактически оказанных Вам специализированной компанией услуг. По истечении года работы в Компании Вы будете освобождены от лежащей на Вас обязанности по возврату суммы займа. В случае прекращения трудовых отношений по любой причине в течение первого года работы Вы будете обязаны полностью вернуть сумму займа.
{% endif %}
{% endif %}

{% if currency.code == 'RUB' and offer.work_place == 'office' %}
В течение первого месяца работы Компания либо оформит Вам банковскую карту того банка, с которым у Компании существует договор, оговаривающий условия и порядок перечисления Компанией заработной платы и иных выплат работникам, либо Вы должны будете предоставить банковские реквизиты того банка, в котором у Вас открыт банковский счет в рублях.
{% endif %}
{% if currency.code == 'RUB' %}
Выплата заработной платы будет производиться два раза в месяц в денежной форме в рублях, в соответствии с действующим российским законодательством.
{% endif %}

Компания будет осуществлять обязательные выплаты, включая обязательные социальные и пенсионные в порядке и на условиях, установленных действующим российским законодательством.

В случае болезни Компания будет производить Вам выплату пособия по временной нетрудоспособности (больничные) в порядке и на условиях, установленных действующим российским законодательством.

{% if offer.sick_leave_supplement %}
При этом, если сумма максимального среднего дневного заработка, из которого исчисляются пособия по временной нетрудоспособности будет менее суммы стоимости Вашего рабочего дня, рассчитанного исходя из оклада за текущий месяц, Компания может производить доплату к указанному пособию до размера должностного оклада, с учетом районного коэффициента, если таковой предусмотрен, за соответствующий месяц, при условии, что период временной нетрудоспособности по совокупности за календарный год не превышает 30 календарных дней.
{% endif %}

Вам будет предоставляться ежегодный основной оплачиваемый отпуск продолжительностью 28 календарных дней.

{% if offer.vmi and headcount %}
В течение первого месяца работы Компания оформит для Вас полис добровольного медицинского страхования, позволяющий получить широкий спектр медицинских услуг. Вы также самостоятельно и за свой счет можете заключить со страховой компанией договоры добровольного медицинского страхования для членов Вашей семьи по льготным корпоративным тарифам.
{% if offer.work_place == 'office' %}
{% if offer.office.city.staff_id == 1 or offer.office.city.staff_id == 2 %}
В офисе Компании по полису ДМС осуществляет прием врач-терапевт и массажист.
{% endif %}
{% endif %}
{% endif %}

{% if has_food_compensation and offer.work_place == 'office' %}
{% if headcount or offer.is_internship %}
Кроме того, Компания организует возможность питания в рабочее время в пределах лимитов, в порядке и на условиях, установленных действующими в Компании политиками. Суммы, израсходованные Вами на питание в пределах лимита, облагаются НДФЛ согласно законодательству РФ.
{% endif %}
{% endif %}

{% if offer.housing_program and offer.contract_type == 'indefinite' %}
Компания также предоставляет своим сотрудникам возможность участия в корпоративной жилищной программе в соответствии с условиями, предусмотренными в политиках Компании.
{% endif %}

{% if offer.cellular_compensation %}
В производственных целях Вам может быть предоставлена корпоративная сотовая связь и мобильный интернет с лимитом, установленным в соответствии с политиками Компании.
{% endif %}

{% if offer.internet_compensation_amount and offer.work_place == 'home' %}
В связи с необходимостью использования сети Интернет для осуществления Вами трудовых обязанностей, Вам будет установлена компенсация затрат на оплату услуг интернет провайдеров в размере {{ offer.internet_compensation_amount|floatformat:-2 }} {{ currency.code }} в месяц.
{% endif %}

Обращаем Ваше внимание, что в первый рабочий день информация о Вашем трудоустройстве будет направлена в электронном виде в Пенсионный Фонд Российской Федерации, а также территориальный орган ЦЗН.

{% if offer.work_place == 'office' and offer.is_main_work_place %}
Адрес офиса, в котором Вы будете работать: {{ offer.office.address_ru }}.

В первый день работы Вам нужно будет принести оригиналы документов, необходимых для трудоустройства:

- Паспорт;
- Справка о сумме заработной платы за последние два года №182-Н (если есть);
- Трудовая книжка (если не переходили на электронную).
{% elif offer.work_place == 'office' and not offer.is_main_work_place %}
Адрес офиса, в котором Вы будете работать: {{ offer.office.address_ru }}.

В первый день работы Вам нужно будет принести оригиналы документов, необходимых для трудоустройства:

- Паспорт;
- Справка о сумме заработной платы за последние два года №182-Н (если есть);
- Трудовая книжка (если не переходили на электронную).
{% elif offer.work_place == 'home' and offer.is_main_work_place %}
Для заключения с Вами трудового договора просим после заполнения анкеты по ссылке, указанной ниже, приложить к ней копии следующих документов:
- Паспорт;
- Справка о сумме заработной платы за последние два года №182-Н (если есть);
- Трудовая книжка (если не переходили на электронную).
- Трудовой договор, приказ о приеме на работу и иные необходимые для трудоустройства документы будут направлены Вам с курьером или почтой. После подписания и/или проставления личной подписи об ознакомлении один экземпляр трудового договора и все остальные документы возвращаются в адрес Компании.
{% if offer.is_autohire%}
{% if offer.hardware_profile_type == 'laptop' %}
Вам также будет доставлено оборудования для работы – ноутбук. Он прибудет с курьером на адрес, который вы заполните в анкете.
{% elif offer.hardware_profile_type == 'token'%}
Вам также будет доставлено оборудования для работы – токен. Он прибудет с курьером на адрес, который вы заполните в анкете.
{% endif %}
{% else %}
Трудовую книжку и справку №182Н нужно будет передать курьеру, который привезет оборудование.
{% endif %}
{% elif offer.work_place == 'home' and not offer.is_main_work_place %}
Для заключения с Вами трудового договора просим после заполнения анкеты по ссылке, указанной ниже, приложить к ней копии следующих документов:
- Паспорт;
- Справка о сумме заработной платы за последние два года №182-Н (если есть);
- Трудовая книжка (если не переходили на электронную).
Трудовой договор, приказ о приеме на работу и иные необходимые для трудоустройства документы будут направлены Вам с курьером или почтой. После подписания и/или проставления личной подписи об ознакомлении один экземпляр трудового договора и все остальные документы возвращаются в адрес Компании.
{% endif %}

{% if offer.work_place == 'office' and join_isoweekday == 2 %}
Если Вы готовы принять наше предложение, пожалуйста:

- Подтвердите или укажите дату выхода на работу (ближайший удобный для Вас вторник, не выпадающий на праздничный день и не являющийся официально перенесенным выходным днем). Вторник - единый день выхода всех новых сотрудников Компании. В этот день коллеги помогут Вам максимально погрузиться в культуру и традиции Яндекса, расскажут о структуре Компании и технологиях;
- Заполните, пожалуйста, анкету по ссылке: {{ fill_form_url }} (желательно заполнить в течение трех дней);
- Приложите к анкете копию паспорта (основную и страницу с пропиской) и копию свидетельства государственного пенсионного страхования. Эти документы понадобятся для своевременной подготовки трудового договора;
- Выберите логин, который будет Вашим адресом электронной почты ~@yandex-team.ru (допускаются латинские буквы и цифры, не менее 4 букв, без точек).
{% endif %}

{% if offer.work_place == 'office' and join_isoweekday == 3 %}
Если Вы готовы принять наше предложение, пожалуйста:

- Подтвердите или укажите дату выхода на работу (ближайшую удобную для Вас среду, не выпадающую на праздничный день и не являющуюся официально перенесенным выходным днем). Среда - единый день выхода всех новых сотрудников Компании. В этот день коллеги помогут Вам максимально погрузиться в культуру и традиции Яндекса, расскажут о структуре Компании и технологиях;
- Заполните, пожалуйста, анкету по ссылке: {{ fill_form_url }} (желательно заполнить в течение трех дней);
- Приложите к анкете копию паспорта (основную и страницу с пропиской) и копию свидетельства государственного пенсионного страхования. Эти документы понадобятся для своевременной подготовки трудового договора;
- Выберите логин, который будет Вашим адресом электронной почты ~@yandex-team.ru (допускаются латинские буквы и цифры, не менее 4 букв, без точек).
{% endif %}

{% if offer.work_place == 'office' and join_isoweekday == -1 %}
Если Вы готовы принять наше предложение, пожалуйста:

- Подтвердите или укажите дату выхода на работу;
- Заполните, пожалуйста, анкету по ссылке: {{ fill_form_url }} (желательно заполнить в течение трех дней);
- Приложите к анкете копию паспорта (основную и страницу с пропиской) и копию свидетельства государственного пенсионного страхования. Эти документы понадобятся для своевременной подготовки трудового договора;
- Выберите логин, который будет Вашим адресом электронной почты ~@yandex-team.ru (допускаются латинские буквы и цифры, не менее 4 букв, без точек).
{% endif %}

{% if offer.work_place == 'home' and join_isoweekday == 3 %}
Если Вы готовы принять наше предложение, пожалуйста:

- Подтвердите или укажите дату выхода на работу (ближайшую удобную для Вас среду, не выпадающую на праздничный день и не являющуюся официально перенесенным выходным днем). Среда - единый день выхода всех новых сотрудников Компании. В этот день коллеги помогут Вам максимально погрузиться в культуру и традиции Яндекса, расскажут о структуре Компании и технологиях;
- Заполните, пожалуйста, в ближайшее время анкету по ссылке: {{ fill_form_url }} (желательно в течение трех дней) и приложите к ней копии документов, указанных выше;
- Выберите логин, который будет Вашим адресом электронной почты ~@yandex-team.ru (допускаются латинские буквы и цифры, не менее 4 букв, без точек).
{% endif %}

{% if offer.work_place == 'home' and join_isoweekday == -1 %}
Если Вы готовы принять наше предложение, пожалуйста:

- Подтвердите или укажите дату выхода на работу;
- Заполните, пожалуйста, в ближайшее время анкету по ссылке: {{ fill_form_url }} и приложите к ней копии документов, указанных выше;
- Выберите логин, который будет Вашим адресом электронной почты ~@yandex-team.ru (допускаются латинские буквы и цифры, не менее 4 букв, без точек).
{% endif %}"""
