PY3TEST()

OWNER(g:tools-femida)

INCLUDE(${ARCADIA_ROOT}/market/lilucrm/tools/postgresql/11.6/recipe.inc)

ENV(IS_ARCADIA=1)
ENV(PYTEST_ADDOPTS=-l --nomigrations -v --create-db)
ENV(DJANGO_SETTINGS_MODULE=intranet.femida.tests.settings)


PEERDIR(
    contrib/python/pytest-django
    contrib/python/pytest-freezegun
    contrib/python/factory-boy

    intranet/femida/src
    intranet/femida/src/actionlog
    intranet/femida/src/api
    intranet/femida/src/applications
    intranet/femida/src/attachments
    intranet/femida/src/beamery
    intranet/femida/src/calendar
    intranet/femida/src/candidates
    intranet/femida/src/celery
    intranet/femida/src/certifications
    intranet/femida/src/comments
    intranet/femida/src/communications
    intranet/femida/src/contest
    intranet/femida/src/core
    intranet/femida/src/export_action
    intranet/femida/src/jobs
    intranet/femida/src/forms_constructor
    intranet/femida/src/frontend
    intranet/femida/src/hh
    intranet/femida/src/hire_orders
    intranet/femida/src/interviews
    intranet/femida/src/isearch
    intranet/femida/src/mail
    intranet/femida/src/monitoring
    intranet/femida/src/notifications
    intranet/femida/src/oebs
    intranet/femida/src/offers
    intranet/femida/src/permissions
    intranet/femida/src/problems
    intranet/femida/src/professions
    intranet/femida/src/publications
    intranet/femida/src/services
    intranet/femida/src/skills
    intranet/femida/src/staff
    intranet/femida/src/startrek
    intranet/femida/src/stats
    intranet/femida/src/templatetags
    intranet/femida/src/users
    intranet/femida/src/utils
    intranet/femida/src/vacancies
    intranet/femida/src/wf
    intranet/femida/src/yt
)

PY_SRCS(
    __init__.py
    clients.py
    conftest.py
    factories.py
    fixtures.py
    models.py
    raw_template.py
    settings.py
    utils.py

    mock/__init__.py
    mock/offers.py
    mock/startrek.py
    mock/contest.py
)

TEST_SRCS(
    integration/__init__.py
    integration/api/__init__.py
    integration/api/conftest.py
    integration/api/test_applications.py
    integration/api/test_applications_dashboard.py
    integration/api/test_assignments.py
    integration/api/test_attachments.py
    integration/api/test_candidates.py
    integration/api/test_categories.py
    integration/api/test_certifications.py
    integration/api/test_challenges.py
    integration/api/test_cities.py
    integration/api/test_comments.py
    integration/api/test_communications.py
    integration/api/test_complaints.py
    integration/api/test_considerations.py
    integration/api/test_considerations_dashboard.py
    integration/api/test_duplication_cases.py
    integration/api/test_external_api.py
    integration/api/test_external_publications.py
    integration/api/test_frontend.py
    integration/api/test_hire_orders.py
    integration/api/test_jobs_suggest.py
    integration/api/test_interviews.py
    integration/api/test_interview_rounds.py
    integration/api/test_monitoring.py
    integration/api/test_offers.py
    integration/api/test_permissions.py
    integration/api/test_preprofiles.py
    integration/api/test_presets.py
    integration/api/test_private_api.py
    integration/api/test_problems.py
    integration/api/test_professions.py
    integration/api/test_public_professions.py
    integration/api/test_public_services.py
    integration/api/test_publications.py
    integration/api/test_references.py
    integration/api/test_reminders.py
    integration/api/test_rotations.py
    integration/api/test_submissions.py
    integration/api/test_suggest.py
    integration/api/test_the_rest.py
    integration/api/test_users.py
    integration/api/test_vacancies.py
    integration/api/test_vacancy_groups.py
    integration/candidates/__init__.py
    integration/candidates/bulk_upload/__init__.py
    integration/candidates/bulk_upload/conftest.py
    integration/candidates/bulk_upload/test_controllers.py
    integration/candidates/bulk_upload/test_forms.py
    integration/candidates/scorings/__init__.py
    integration/candidates/scorings/test_controllers.py
    integration/conftest.py
    integration/contest/__init__.py
    integration/contest/conftest.py
    integration/contest/mock.py
    integration/contest/test_contest_api_helpers.py
    integration/contest/test_handle_internship_submission.py
    integration/contest/test_sync_contest_results.py
    integration/deduplication/__init__.py
    integration/deduplication/conftest.py
    integration/deduplication/test_finder.py
    integration/deduplication/test_similarity.py
    integration/export_action/__init__.py
    integration/export_action/test_export_action.py
    integration/frontend/__init__.py
    integration/frontend/conftest.py
    integration/frontend/test_candidate_redirection.py
    integration/hire_orders/__init__.py
    integration/hire_orders/conftest.py
    integration/hire_orders/test_controllers.py
    integration/hire_orders/test_smoke.py
    integration/hire_orders/test_workflow.py
    integration/interviews/__init__.py
    integration/interviews/yang/__init__.py
    integration/interviews/yang/test_controllers.py
    integration/notifications/__init__.py
    integration/notifications/test_applications.py
    integration/notifications/test_candidates.py
    integration/notifications/test_challenges.py
    integration/notifications/test_comments.py
    integration/notifications/test_communications.py
    integration/notifications/test_interviews.py
    integration/notifications/test_offers.py
    integration/notifications/test_problems.py
    integration/notifications/test_publication_subscriptions.py
    integration/notifications/test_vacancies.py
    integration/offers/__init__.py
    integration/offers/controllers/__init__.py
    integration/offers/controllers/test_triggers.py
    integration/offers/test_startrek.py
    integration/offers/test_workflow.py
    integration/preprofiles/__init__.py
    integration/preprofiles/test_controllers.py
    integration/stats/__init__.py
    integration/submissions/__init__.py
    integration/submissions/test_controllers.py
    integration/tasks/__init__.py
    integration/tasks/test_candidates.py
    integration/yt/__init__.py
    integration/yt/test_tasks.py

    unit/__init__.py
    unit/applications/__init__.py
    unit/applications/test_controllers.py
    unit/applications/test_helpers.py
    unit/applications/test_tasks.py
    unit/calendar/__init__.py
    unit/calendar/test_api.py
    unit/calendar/test_tasks.py
    unit/candidates/__init__.py
    unit/candidates/bulk_upload/__init__.py
    unit/candidates/bulk_upload/test_controllers.py
    unit/candidates/bulk_upload/test_forms.py
    unit/candidates/bulk_upload/test_serializers.py
    unit/candidates/conftest.py
    unit/candidates/filters/__init__.py
    unit/candidates/filters/test_forms.py
    unit/candidates/filters/test_serializers.py
    unit/candidates/filters/test_filters.py
    unit/candidates/test_candidates.py
    unit/candidates/test_contacts.py
    unit/candidates/test_deduplication.py
    unit/candidates/test_managers.py
    unit/candidates/test_tasks.py
    unit/candidates/test_workflow.py
    unit/communications/__init__.py
    unit/communications/test_communications.py
    unit/considerations/__init__.py
    unit/considerations/test_calculate_extended_status.py
    unit/considerations/test_consideration_issues.py
    unit/core/__init__.py
    unit/core/controllers/__init__.py
    unit/core/controllers/test_update_instance.py
    unit/core/controllers/test_update_list_of_instances.py
    unit/core/db/__init__.py
    unit/core/db/test_expressions.py
    unit/core/db/test_lookups.py
    unit/core/test_middleware.py
    unit/dependencies/__init__.py
    unit/dependencies/test_django_celery_results.py
    unit/dependencies/test_kombu.py
    unit/forms_constructor/__init__.py
    unit/forms_constructor/test_controllers.py
    unit/hire_orders/__init__.py
    unit/hire_orders/test_signals.py
    unit/interviews/__init__.py
    unit/interviews/startrek/__init__.py
    unit/interviews/startrek/test_issues.py
    unit/interviews/test_controllers.py
    unit/interviews/test_helpers.py
    unit/interviews/test_permissions.py
    unit/interviews/test_tasks.py
    unit/interviews/test_visibility.py
    unit/notifications/__init__.py
    unit/notifications/test_base.py
    unit/oebs/__init__.py
    unit/oebs/test_api.py
    unit/offers/__init__.py
    unit/offers/controllers/__init__.py
    unit/offers/controllers/test_newhire_actions.py
    unit/offers/controllers/test_oebs_controllers.py
    unit/offers/controllers/test_schemes_controller.py
    unit/offers/test_fetch_newhire_data.py
    unit/offers/test_forms.py
    unit/offers/test_helpers.py
    unit/offers/test_login_validation.py
    unit/offers/test_managers.py
    unit/offers/test_offer_bonus.py
    unit/offers/test_serializers.py
    unit/offers/test_tasks.py
    unit/offers/test_workflow.py
    unit/problems/__init__.py
    unit/problems/test_helpers.py
    unit/publications/__init__.py
    unit/publications/test_controllers.py
    unit/publications/test_facet_counters.py
    unit/publications/test_tasks.py
    unit/rotations/__init__.py
    unit/rotations/test_controllers.py
    unit/staff/__init__.py
    unit/staff/test_achievements.py
    unit/staff/test_department_user_sync.py
    unit/staff/test_helpers.py
    unit/staff/test_models.py
    unit/staff/test_value_streams_sync.py
    unit/staff/test_geographies_sync.py
    unit/staff/utils/__init__.py
    unit/staff/utils/api.py
    unit/staff/utils/db.py
    unit/stats/__init__.py
    unit/stats/fetchers/__init__.py
    unit/stats/fetchers/test_offers.py
    unit/stats/test_configs.py
    unit/stats/test_data_fetchers.py
    unit/submissions/__init__.py
    unit/submissions/test_helpers.py
    unit/templatetags/__init__.py
    unit/templatetags/test_utils.py
    unit/users/__init__.py
    unit/users/test_models.py
    unit/users/test_utils.py
    unit/utils/__init__.py
    unit/utils/test_flags.py
    unit/utils/test_forms.py
    unit/utils/test_pluralization.py
    unit/utils/test_queryset.py
    unit/utils/test_strings.py
    unit/vacancies/__init__.py
    unit/vacancies/test_controllers.py
    unit/vacancies/test_history.py
    unit/vacancies/test_publication_subscriptions.py
    unit/vacancies/test_ranking.py
    unit/vacancies/test_issue.py
    unit/verifications/__init__.py
    unit/verifications/test_controllers.py
    unit/yang/__init__.py
    unit/yang/test_controllers.py
    unit/yt/__init__.py
    unit/yt/test_loaders.py
    unit/yt/test_tasks.py
)

NO_CHECK_IMPORTS()
NO_DOCTESTS()

SIZE(MEDIUM)

END()
