# -*- coding: utf-8 -*-
import json
import logging

from .conf import global_settings


def get_log_context():
    pass


class JsonFormatter(logging.Formatter):
    pretty_params = {'indent': 2, 'sort_keys': True, 'ensure_ascii': False}

    def __init__(self, *args, **kwargs):
        kwargs.pop('use_colors', None)
        super().__init__(*args, **kwargs)

    def format(self, record):
        context = get_log_context() or {}
        request = context.get('request') or {}
        user = context.get('user') or {}

        log_data = {
            'message': record.getMessage(),
            'levelStr': record.levelname,
            'loggerName': record.name,
            'level': record.levelno,
            'request_id': request.get('id'),
            'user_id': user.get('uid'),
            '@fields': {
                'context': context,
                'std': {
                    'orig_msg': record.msg,
                },
            },
        }

        if record.exc_info:
            exc = logging.Formatter.formatException(self, record.exc_info)
            log_data['stackTrace'] = exc

        params = {}
        if global_settings.pretty_logs:
            params = self.pretty_params
        return json.dumps(log_data, **params)
