# -*- coding: utf-8 -*-
import json

from sqlalchemy import (
    Column, Integer, String, Boolean, Table, MetaData,
)
from sqlalchemy.types import TypeDecorator


metadata = MetaData()


class JSONString(TypeDecorator):
    impl = String

    def process_bind_param(self, value, dialect):
        if value is not None:
            value = json.dumps(value)
        return value

    def process_result_value(self, value, dialect):
        if value is not None:
            value = json.loads(value)
        return value


User = Table(
    'auth_user', metadata,
    Column('id', Integer, primary_key=True, key='pk'),
    Column('username', String(30)),
    Column('email', String(254)),
    Column('is_staff', Boolean),
    Column('is_superuser', Boolean),
    Column('uid', String(20)),
    Column('cloud_uid', String(255)),
)
