# -*- coding: utf-8 -*-
from fastapi import Request

from .auth import SessionCookieAuth, TvmServiceAuth


class BaseUser:
    def is_authenticated(self):
        raise NotImplementedError

    @property
    def authenticated(self):
        return self.is_authenticated()


class AnonymousUser(BaseUser):
    def is_authenticated(self):
        return False

    def __repr__(self):
        return 'AnonymousUser()'


class LoggedUser(BaseUser):
    def is_authenticated(self):
        return True


class YandexUser(LoggedUser):
    def __init__(self, uid):
        self.uid = uid

    def __repr__(self):
        return f'YandexUser({self.uid})'


class ServiceUser(YandexUser):
    def __init__(self, src, uid):
        super().__init__(uid)
        self.src = src

    def __repr__(self):
        return f'ServiceUser({self.src}, {self.uid})'


async def get_yauser(request: Request):
    auth_classes = (TvmServiceAuth, SessionCookieAuth)
    for auth_class in auth_classes:
        auth_inst = auth_class()
        yauser = await auth_inst.auth(request)
        if yauser:
            return yauser
    return AnonymousUser()
