# -*- coding: utf-8 -*-
import pytz
import socket

from importlib import import_module


def datetime_now():
    return pytz.datetime.datetime.utcnow().replace(tzinfo=pytz.utc)


def get_localhost_ip():
    hostname = socket.gethostname()
    try:
        return socket.gethostbyaddr(hostname)[2][0]
    except socket.gaierror:
        _, _, _, _, sockaddr = socket.getaddrinfo(hostname, None, socket.AF_INET6)[0]
        return sockaddr[0]


_instance_ip = None


def get_instance_ip():
    global _instance_ip
    if not _instance_ip:
        _instance_ip = get_localhost_ip()
    return _instance_ip


def import_from_string(full_class_name):
    parts = full_class_name.split('.')
    if len(parts) == 1:
        module = locals()
    else:
        module = import_module('.'.join(parts[:-1]))
    return getattr(module, parts[-1], None)
