#!/bin/bash

arcadiapath=$HOME/arcadia

service=$1
shift

if [ "$service" == "tests" ]; then
    action=$service
else 
    action=$1
fi

case $action in
    server)
        command="Y_PYTHON_SOURCE_ROOT=$arcadiapath
                 UVICORN_PORT=8080
                 UVICORN_LOGLEVEL=debug
                 UVICORN_RELOAD=1
                 $service/build/forms_$service"
        echo $command
        eval $command
        ;;
    shell)
        command="Y_PYTHON_SOURCE_ROOT=$arcadiapath
                 Y_PYTHON_ENTRY_POINT=IPython:start_ipython
                 $service/build/forms_$service"
        echo $command
        eval $command
        ;;
    tests)
        command="ya make -A $(../devtools/test_args.py $*)"
        echo $command
        eval $command
        ;;
esac
