# -*- coding: utf-8 -*-
import os
import uvicorn

from intranet.forms.micro.core.src.types import EnvTypes
from intranet.forms.micro.simple.src.conf import settings


def main():
    reload_dirs = [os.path.join(os.path.dirname(__file__), '..', '..')]
    params = {
        'host': '::',
        'port': settings.uvicorn_port,
        'log_level': settings.uvicorn_loglevel,
        'reload': settings.uvicorn_reload,
        'reload_dirs': reload_dirs,
    }

    if settings.pretty_logs or settings.env_type != EnvTypes.development:
        for formatter in uvicorn.config.LOGGING_CONFIG['formatters'].values():
            formatter['()'] = 'intranet.forms.micro.core.src.logs.JsonFormatter'

    uvicorn.run('intranet.forms.micro.simple.src.main:app', **params)


if __name__ == '__main__':
    main()
