# -*- coding: utf-8 -*-
import os

from fastapi import APIRouter, Request
from pydantic import BaseModel
from typing import Optional

from intranet.forms.micro.core.src.db import get_pool
from intranet.forms.micro.core.src.types import StatusTypes
from .conf import settings as global_settings


router = APIRouter()


async def get_system_info(settings, yauser):
    pool = get_pool(settings.app_type)
    async with pool.acquire_replica() as conn:
        sql = 'select current_database() as dbname, "current_user"() as dbuser'
        result = await conn.execute(sql)
        db_name, db_user = '', ''
        async for row in result:
            db_name = row['dbname']
            db_user = row['dbuser']
    app_version = os.environ.get('APP_VERSION', 'develop')
    return {
        'app_name': global_settings.app_name,
        'env_type': global_settings.env_type,
        'app_type': settings.app_type,
        'db_name': db_name,
        'db_user': db_user,
        'yauser': str(yauser),
        'version': app_version,
    }


@router.get('/')
async def index(request: Request):
    settings = request.scope['settings']
    yauser = request.scope['yauser']
    result = await get_system_info(settings, yauser)
    return result


@router.get('/status/{id}')
async def get_status(
    id: int,
):
    return {
        'id': id,
        'status': StatusTypes.success,
    }


class NotificationModel(BaseModel):
    id: int
    delay: Optional[int] = 0
    retry: Optional[int] = 0


@router.post('/start')
async def start(
    notification: NotificationModel,
):
    return notification


@router.post('/stop')
async def stop(
    notification: NotificationModel,
):
    return notification
