var express = require('express');
var router = express.Router();

const transform = require('@doc-tools/transform');

/* GET home page. */
router.get('/', function(req, res, next) {
    res.send({express: 'ok'})
});

router.post('/transform/', function(req, res, next) {
    const content = req.body.content;
    const vars = req.body.vars;
    const {result: {html, meta}, logs} = transform(content, {vars, plugins: []});
    res.send({html});
});

module.exports = router;
