#!/bin/bash

set -e

APPLICATIONS=""
while (( "$#" )); do
  case "$1" in
    -s|--stand)
      if [ -n "$2" ]; then
        STAND_TICKET=$2
        shift 2
      else
        echo "Error: Name of stand is missing" >&2
        exit 1
      fi
      ;;
    -*|--*=) # unsupported flags
      echo "Error: Unsupported flag $1" >&2
      exit 1
      ;;
    *) # preserve positional arguments
      APPLICATIONS="${APPLICATIONS} $1"
      shift
      ;;
  esac
done

if [ -z "${STAND_TICKET}" ]; then
  STAND_TICKET=$(releaser stand-ticket \
                        --no-get-ticket-from-last-commit-message \
                        --get-ticket-from-current-branch-name \
                   | tr '[:upper:]' '[:lower:]')
fi

if [ -z "${APPLICATIONS}" ]; then
  APPLICATIONS="forms_int forms_ext forms_ext_admin forms_biz"
fi

for application in $(echo "${APPLICATIONS}" | tr ' ' '\n'); do
  case "${application}" in
    forms_int)
        releaser env-dump \
                 --project tools \
                 --application forms-back-int \
                 --environment testing \
                 --dump "forms-back-int.json"

        releaser stand \
                 --components 'backend(ALL=1),celery-beat(ALL=1),celery-worker(ALL=1),console(ALL=1)' \
                 --dockerfile Dockerfile \
                 --project tools \
                 --applications forms-back-int \
                 --standname "stand-${STAND_TICKET}" \
                 --image registry.yandex.net/tools/forms-backend \
                 --dump forms-back-int.json \
                 --domain-tpl "${STAND_TICKET}-int.forms-api.test.yandex-team.ru" \
                 --domain-type forms-test \
                 --no-get-ticket-from-last-commit-message \
                 --get-ticket-from-current-branch-name \
                 --var "ENVIRONMENT=testing" \
                 --var "STAND_TICKET=${STAND_TICKET}"

        rm forms-back-int.json
    ;;
    forms_ext)
        releaser env-dump \
                 --project tools \
                 --application forms-back-ext \
                 --environment testing \
                 --dump "forms-back-ext.json"

        releaser stand \
                 --components 'backend(ALL=1),celery-beat(ALL=1),celery-worker(ALL=1),console(ALL=1)' \
                 --dockerfile Dockerfile \
                 --project tools \
                 --applications forms-back-ext \
                 --standname "stand-${STAND_TICKET}" \
                 --image registry.yandex.net/tools/forms-backend \
                 --dump forms-back-ext.json \
                 --domain-tpl "${STAND_TICKET}-ext.forms-api.test.yandex.ru" \
                 --domain-type forms-test \
                 --no-get-ticket-from-last-commit-message \
                 --get-ticket-from-current-branch-name \
                 --var "ENVIRONMENT=testing" \
                 --var "STAND_TICKET=${STAND_TICKET}"

        rm forms-back-ext.json
    ;;
    forms_ext_admin)
        releaser env-dump \
                 --project tools \
                 --application forms-back-ext-admin \
                 --environment testing \
                 --dump "forms-back-ext-admin.json"

        releaser stand \
                 --components 'backend(ALL=1),console(ALL=1)' \
                 --dockerfile Dockerfile \
                 --project tools \
                 --applications forms-back-ext-admin \
                 --standname "stand-${STAND_TICKET}" \
                 --image registry.yandex.net/tools/forms-backend \
                 --dump forms-back-ext-admin.json \
                 --domain-tpl "${STAND_TICKET}-ext.forms-api.test.yandex-team.ru" \
                 --domain-type forms-test \
                 --no-get-ticket-from-last-commit-message \
                 --get-ticket-from-current-branch-name \
                 --var "ENVIRONMENT=testing" \
                 --var "STAND_TICKET=${STAND_TICKET}"

        rm forms-back-ext-admin.json
    ;;
    forms_biz)
        releaser env-dump \
                 --project tools-b2b \
                 --application forms-back-biz \
                 --environment testing \
                 --dump "forms-back-biz.json"

        releaser stand \
                 --components 'backend(ALL=1),celery-beat(ALL=1),celery-worker(ALL=1),console(ALL=1)' \
                 --dockerfile Dockerfile \
                 --project tools-b2b \
                 --applications forms-back-biz \
                 --standname "stand-${STAND_TICKET}" \
                 --image registry.yandex.net/tools/forms-backend \
                 --dump forms-back-biz.json \
                 --domain-tpl "${STAND_TICKET}-biz.forms-api.test.yandex.ru" \
                 --domain-type forms-test \
                 --no-get-ticket-from-last-commit-message \
                 --get-ticket-from-current-branch-name \
                 --var "ENVIRONMENT=testing" \
                 --var "STAND_TICKET=${STAND_TICKET}"

        rm forms-back-biz.json
    ;;
  esac
done

scripts/front_stand.py create "${STAND_TICKET}" ${APPLICATIONS}
