# -*- coding: utf-8 -*-
import argparse
import os
import yenv
from library.python.vault_client.instances import Production as VaultClient

if yenv.type == 'production':
    SECRET_UUID = 'sec-01ckjwkyqtymwz0pwjdxar1amw'
elif yenv.type == 'preprod':
    SECRET_UUID = 'sec-01f3mmxt1c3yv54zb0e60jtenw'
else:
    SECRET_UUID = 'sec-01ckjvwm295kfcefn4xvt53cba'

SECRET_OUTPUT_PATH = '/etc/yandex/tools-datasources/datasources.py'
SECRET_NAME = 'secret'


def get_secret_data(secret_uuid, secret_name):
    vault_token = os.environ.get('vault_token')
    client = VaultClient(decode_files=True, authorization=f'OAuth {vault_token}')
    head_version = client.get_version(secret_uuid)
    value = head_version['value']
    return value[secret_name]


def write_file(file_path, secret_data):
    os.makedirs(os.path.dirname(file_path), exist_ok=True)
    with open(file_path, 'w') as f:
        f.write(secret_data)


def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-n', '--name', default=SECRET_NAME, help='Secret name')
    parser.add_argument('-u', '--uuid', default=SECRET_UUID, help='Secret UUID')
    parser.add_argument('-o', '--output-path', default=SECRET_OUTPUT_PATH, help='Output secret path')
    return parser.parse_args()


def main():
    args = get_args()
    secret_data = get_secret_data(args.uuid, args.name)
    write_file(args.output_path, secret_data)


if __name__ == '__main__':
    main()
