# -*- coding: utf-8 -*-
import json
from django.db import models

from events.abc.managers import AbcServiceManager
from events.common_app.models import Md5sumMixin
from events.translation.models import TranslationModel


class AbcService(Md5sumMixin, TranslationModel):
    FIELDS_FOR_TRANSLATION = ('name', )

    abc_id = models.PositiveIntegerField('ID на стаффе', unique=True, db_index=True)
    name = models.CharField(max_length=255)
    slug = models.CharField(max_length=255)
    is_deleted = models.BooleanField(default=False, db_index=True)
    is_active = models.BooleanField(default=False, db_index=True)

    objects = AbcServiceManager()

    def __str__(self):
        return 'Сервис "%s"' % self.name

    @classmethod
    def calc_md5sum(cls, name, translations, slug, is_active, is_deleted):
        return cls._calc_md5sum(
            name,
            json.dumps(translations, sort_keys=True, ensure_ascii=False),
            slug,
            is_active,
            is_deleted,
        )

    def md5(self):
        return self.calc_md5sum(
            self.name,
            self.translations,
            self.slug,
            self.is_active,
            self.is_deleted,
        )

    def get_name(self):
        return self.get_translated_field('name')
