# -*- coding: utf-8 -*-
from events.abc.client import AbcClient, ROLE_TVM_MANAGER, ROLE_FORM_MANAGER


def has_role_tvm_or_form_manager(tvm_client: str, uid: str) -> bool:
    client = AbcClient()
    has_role = False
    for service in client.get_services_by_tvm_client(tvm_client):
        if client.has_roles_in_service(service, [ROLE_TVM_MANAGER, ROLE_FORM_MANAGER], uid=uid):
            has_role = True
            break
    return has_role
