# -*- coding: utf-8 -*-
import django_filters

from django.db.models import Q
from django.contrib.auth.models import Group, Permission

from events.accounts.models import User
from events.rest_framework_contrib import queryset_filters


class GroupFilter(django_filters.FilterSet):
    class Meta:
        model = Group
        fields = (
            'id',
        )


class UserFilter(django_filters.FilterSet):
    search = queryset_filters.MethodFilter('filter_by_fit_for_search_text')

    class Meta:
        model = User
        fields = (
            'id',
            'username',
            'email',
        )


class GroupGlobalPermissionsFilter(django_filters.FilterSet):
    def startswith_list_filter(qs, value):
        condition = None
        if not value:
            return qs
        for v in value.split(','):
            if not condition:
                condition = Q(codename__startswith=v)
            else:
                condition = condition | Q(codename__startswith=v)
        return qs.filter(condition)

    codename_starts_with_prefixes = django_filters.Filter(method=startswith_list_filter)

    class Meta:
        model = Permission
        fields = (
            'codename_starts_with_prefixes',
        )
