# -*- coding: utf-8 -*-
import factory

from django.contrib.auth.models import Group

from events.accounts.models import (
    GrantTransitionInfo,
    Organization,
    OrganizationToGroup,
    User,
)


class OrganizationFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = Organization

    dir_id = factory.Sequence(lambda n: f'1{n:-05}')


class UserFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = User

    username = factory.Sequence(lambda n: f'user-{n}')
    email = factory.Sequence(lambda n: f'user-{n}@yandex-team.ru')
    uid = factory.Sequence(lambda n: f'111{n:-013}')


class GroupFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = Group

    name = factory.Sequence(lambda n: f'group:1{n:-05}')


class OrganizationToGroupFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = OrganizationToGroup

    org = factory.SubFactory(OrganizationFactory)
    group = factory.SubFactory(GroupFactory)


class GrantTransitionInfoFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = GrantTransitionInfo

    new_user = factory.SubFactory(UserFactory)
    old_user = factory.SubFactory(UserFactory)
