# -*- coding: utf-8 -*-
from events.accounts.factories import UserFactory
from events.yauth_contrib.helpers import CookieClient


class YandexClient(CookieClient):
    def login_yandex(self, **params):
        user = UserFactory(**params)
        self.set_cookie(user.uid)
        return user

    def logout_yandex(self):
        self.remove_cookie()


def get_passport_data(uid):
    data = {
        '1120000000009214': {
            'uid': '1120000000009214',
            'fields': {
                'login': 'zomb-prj-124',
                'fio': 'zomb-prj-124 zomb-prj-124',
            },
            'default_email': 'zomb-prj-124@yandex-team.ru',
        },
        '1120000000026301': {
            'uid': '1120000000026301',
            'fields': {
                'login': 'ludkr',
                'fio': 'Крыжановская Людмила',
            },
            'default_email': 'ludkr@yandex-team.ru',
        },
        '1120000000016772': {
            'uid': '1120000000016772',
            'fields': {
                'login': 'smosker',
                'fio': 'Колясинский Владимир',
            },
            'default_email': 'smosker@yandex-team.ru',
        },
        '1120000000016799': {
            'uid': '1120000000016799',
            'fields': {
                'login': 'smoskerYan',
                'fio': u'Колясинский Владимир',
            },
            'default_email': 'smoskerYan@yandex.ru',
        },
        '11591176': {
            'uid': '11591176',
            'fields': {
                'login': 'user1',
                'fio': 'Pupkin Vasily',
            },
        },
        '100500100500': {
            'uid': '100500100500',
            'fields': {
                'login': 'gubkin',
                'fio': 'Губкин Иван',
            },
        },
        '1120000000016876': {
            'uid': '1120000000016876',
            'fields': {
                'login': 'uldin',
                'fio': 'Ульдин Андрей',
            },
        },
        '1130000023386160': {
            'uid': '1130000023386160',
            'fields': {
            },
        },
        '1130000023386161': {
            'uid': '1130000023386161',
            'fields': {
            },
        },
        '1120000000037913': {
            'uid': '1120000000037913',
            'fields': {
                'login': 'robot-forms-test',
            },
        },
        '1120000000106806': {
            'uid': '1120000000106806',
            'fields': {
                'login': 'robot-forms-test',
            },
        },
        '1120000000011847': {
            'uid': '1120000000011847',
            'fields': {
                'login': 'robot-forms-test',
            },
        },
        '1120000000072846': {
            'uid': '1120000000072846',
            'fields': {
                'login': 'ashki',
            },
        },
        '1120000000000529': {
            'uid': '1120000000000529',
            'fields': {
                'login': 'volozh',
            },
        },
        '1120000000000251': {
            'uid': '1120000000000251',
            'fields': {
                'login': 'tigran',
            },
        },
        '1120000000001062': {
            'uid': '1120000000001062',
            'fields': {
                'login': 'bunina',
            },
        },
        '11591999': {
            'uid': '11591999',
            'fields': {
                'login': 'not_in_db',
                'fio': 'Not Saved',
            },
            'default_email': 'not_in_db@yandex.ru',
        },
    }
    return data.get(str(uid), {})
