# -*- coding: utf-8 -*-
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0002_forms_7492'),
    ]

    operations = [
        migrations.CreateModel(
            name='GrantTransitionInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('object_pk', models.CharField(max_length=255)),
                ('content_type', models.ForeignKey(on_delete=models.CASCADE, to='contenttypes.ContentType')),
                ('new_user', models.ForeignKey(on_delete=models.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('old_user', models.ForeignKey(on_delete=models.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddIndex(
            model_name='granttransitioninfo',
            index=models.Index(fields=['content_type', 'object_pk'], name='granttransitioninfo_ct_pk_idx'),
        ),
    ]
