# -*- coding: utf-8 -*-
from django.contrib.admin.widgets import AdminFileWidget
from django.db import models
from django.db.models.fields.files import ImageFieldFile
from django.utils.safestring import mark_safe

from events.avatars_extra.storage import AvatarsStorage


class AvatarFieldFile(ImageFieldFile):
    def get_thumb_url(self, *args, **kwargs):
        """Proxy на метод self.storage._get_thumb_url"""
        args = list(args)
        args.insert(0, self.name)
        return self.storage._get_thumb_url(*args, **kwargs)


class AvatarAdminFileWidget(AdminFileWidget):
    def render(self, name, value, attrs=None):
        html = super(AvatarAdminFileWidget, self).render(name=name, value=value, attrs=attrs)

        if value and hasattr(value, 'url'):
            html += mark_safe(('<div style="margin-left: 108px; margin-top: 2px;">'
                                   '<a href="%(src)s">'
                                       '<img src="%(src)s">'
                                    '</a>'
                               '</div>') % {'src': value.url})
        return html


class AvatarImageField(models.ImageField):
    attr_class = AvatarFieldFile

    def __init__(self, *args, **kwargs):
        kwargs.setdefault('storage', AvatarsStorage())
        kwargs.setdefault('upload_to', '/')
        self.storage = AvatarsStorage()
        self.upload_to = '/'
        super(AvatarImageField, self).__init__(*args, **kwargs)

    def formfield(self, **kwargs):
        kwargs = {'widget': AvatarAdminFileWidget}
        return super(AvatarImageField, self).formfield(**kwargs)
