# -*- coding: utf-8 -*-
from uuid import uuid4
import hashlib

from django.conf import settings
from django.test.client import encode_multipart
from events.common_app.utils import requests_session


def generate_code():
    salt = settings.SECRET_KEY.encode()
    code = str(uuid4()).encode()
    hash1 = hashlib.md5(code).hexdigest().encode()
    hash2 = hashlib.md5(hash1 + salt).hexdigest()
    return hash2


def post_multipart(url, data):
    """Sends multipart request to url

    @param url: example - 'http://google.com/post-here/
    @param data: example - {'id': 'hello', 'file': open('google.jpg')}

    @type url: str
    @type data: dict
    @rtype: io

    """
    # todo: test me
    boundary = '----------Web_ChiB_BoUnDaRy_$'
    data = encode_multipart(boundary, data)

    content_type = 'multipart/form-data; boundary=%s' % boundary
    headers = {
        'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:10.0.2) Gecko/20100101 Firefox/10.0.2',
        'Content-Type': content_type
    }

    response = requests_session(url, data, headers=headers, timeout=settings.DEFAULT_TIMEOUT)
    return response.content
