# -*- coding: utf-8 -*-
from rest_framework import serializers

from events.rest_framework_contrib.serializers import InternalModelSerializerV2Mixin
from events.balance.models import Ticket, Order, BalanceOrder


class TicketSerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    survey_id = serializers.IntegerField()

    class Meta:
        model = Ticket
        fields = (
            'id',
            'survey_id',
            'price',
            'name',
            'trust_return_path',
            'quantity',
            'is_can_pay_by_yandex_money',
            'currency',
        )


class BalanceOrderSerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    class Meta:
        model = BalanceOrder
        fields = (
            'id',
            'price',
            'service_order_id',
            'quantity',
            'currency',
        )


class OrderSerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    profile_survey_answer_id = serializers.IntegerField()
    ticket_info = TicketSerializer()
    balance_orders = BalanceOrderSerializer(many=True)

    class Meta:
        model = Order
        fields = (
            'id',
            'profile_survey_answer_id',
            'payment_status_code',
            'payment_start_datetime',
            'ticket_info',
            'trust_payment_id',
            'payment_status',
            'balance_orders',
            'metadata',
        )
