# -*- coding: utf-8 -*-
from rest_framework import viewsets

from events.balance.api_admin.v2.serializers import TicketSerializer, OrderSerializer
from events.balance.api_admin.v2.filters import OrderFilter
from events.rest_framework_contrib.mixins import InternalGenericApiViewV2Mixin
from events.balance.models import Ticket, Order


class TicketViewSet(InternalGenericApiViewV2Mixin, viewsets.ModelViewSet):
    serializer_class = TicketSerializer
    queryset = Ticket.objects.select_related('survey')


class OrderViewSet(InternalGenericApiViewV2Mixin, viewsets.ReadOnlyModelViewSet):
    serializer_class = OrderSerializer
    queryset = Order.objects.select_related('ticket_info').prefetch_related('balance_orders')
    filter_class = OrderFilter
