# -*- coding: utf-8 -*-
from django.apps import AppConfig
from django.db.models.signals import post_save, pre_save


class BalanceConfig(AppConfig):
    name = 'events.balance'

    def ready(self):
        from events.balance.models import Ticket
        from events.balance.signals import (
            generate_trust_unsuccessful_return_path,
            save_info_to_balance,
            create_default_trust_texts_for_survey,
        )

        pre_save.connect(generate_trust_unsuccessful_return_path, sender=Ticket)
        post_save.connect(save_info_to_balance, sender=Ticket)
        post_save.connect(create_default_trust_texts_for_survey, sender=Ticket)
