# -*- coding: utf-8 -*-
import factory
import factory.django

from django.db.models.signals import post_save

from events.balance.models import Ticket, Order, BalanceOrder
from events.surveyme.factories import SurveyFactory, ProfileSurveyAnswerFactory


@factory.django.mute_signals(post_save)
class TicketFactory(factory.django.DjangoModelFactory):
    survey = factory.SubFactory(SurveyFactory)
    price = factory.LazyAttribute(lambda x: 1000)

    class Meta:
        model = Ticket


class OrderFactory(factory.django.DjangoModelFactory):
    ticket_info = factory.SubFactory(TicketFactory)
    profile_survey_answer = factory.SubFactory(ProfileSurveyAnswerFactory)
    user_ip = factory.LazyAttribute(lambda x: '127.0.0.1')

    class Meta:
        model = Order


class BalanceOrderFactory(factory.django.DjangoModelFactory):
    service_order_id = '1234589339'
    price = 100

    class Meta:
        model = BalanceOrder
