# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand
from django.db import transaction

from events.common_app.utils import YLockCommandMixin
from events.balance.models import Order
from events.surveyme_integration.tasks import start_integrations


class MainCommand(BaseCommand):
    help = """Проверяет статусы платежей"""

    @transaction.atomic()
    def handle(self, *args, **options):
        for order in Order.objects.select_for_update().filter(payment_status__in=['', 'wait_for_notification']):
            old_status = order.payment_status
            status = order.check_status()
            if status:
                print('Order id:"{0}" old_status:"{1}" new_status:"{2}"'.format(order.id, old_status, status))
                # todo: test below
                if status == 'success':
                    start_integrations(
                        survey_id=order.profile_survey_answer.survey_id,
                        answer_id=order.profile_survey_answer_id,
                        trigger_slug='successful_payment',
                        trigger_data={'order_id': order.id}
                    )


class Command(YLockCommandMixin, MainCommand):
    lock_name = 'events.billing.check_payments_status'
