# -*- coding: utf-8 -*-
from events.balance import utils as balance_utils


def save_info_to_balance(sender, instance, created, *args, **kwargs):
    """
    @type instance: events.balance.models.Ticket
    """
    balance_client = balance_utils.get_balance_client_for_currency(instance.currency)
    balance_client.create_service_product(
        service_product_id=instance.id,
        name=instance.name,
        currency=instance.currency,
        prices=[instance.price],
        product_qty=instance.quantity,
    )


def create_default_trust_texts_for_survey(sender, instance, created, *args, **kwargs):
    """
    @type instance: events.balance.models.Ticket
    """
    if created:
        instance.survey.create_trust_texts()


def generate_trust_unsuccessful_return_path(sender, instance, *args, **kwargs):
    if not instance.pk and not instance.trust_unsuccessful_return_path:
        instance.trust_unsuccessful_return_path = instance.survey.get_frontend_url(
            is_with_site=True,
            external=True,
        )
