# -*- coding: utf-8 -*-
from django.conf import settings

from events.balance.balance_client import BalanceClient
from events.balance.exceptions import BalanceUnknownService


def get_balance_client_for_currency(currency):
    service = get_balance_serive_by_currency(currency)
    if not service:
        raise BalanceUnknownService('unknown service for currency %s' % currency)
    return BalanceClient(token=service['token'])


def get_balance_serive_by_currency(currency):
    return settings.BALANCE_SERVICES_BY_CURRENCY.get(currency)
