# -*- coding: utf-8 -*-
from django.conf import settings

from rest_framework import views
from rest_framework.response import Response

from events.captcha.captcha import Captcha
from events.rest_framework_contrib.mixins import ExternalGenericApiViewV1Mixin
from events.rest_framework_contrib.permissions import AuthorizedFrontendOnly


class CaptchaView(ExternalGenericApiViewV1Mixin, views.APIView):
    create_on_missing = False
    permission_classes = (AuthorizedFrontendOnly,)

    def post(self, request, *args, **kwargs):
        captcha_type = request.data.get('captcha_type', settings.CAPTCHA_TYPE)
        image_url, captcha_key = Captcha().generate(type=captcha_type)
        data = {
            'image_url': image_url,
            'key': captcha_key,
        }
        return Response(data=data)
