# -*- codecs: utf-8 -*-

import re
import os
import functools
import ylock

from ylock.decorators import locked
from celery import Celery, Task
from django.conf import settings
from django_tools_log_context.celery import CtxAwareMixin
from ylog.context import log_context
import collections.abc


os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'events.settings')
re._pattern_type = re.Pattern


def locked_task(func_or_name):

    def _wrap_func(func, lock_name=None, ):
        if lock_name is None:
            lock_name = func.__name__

        @functools.wraps(func)
        @locked(lock_name, ylock.create_manager(**settings.YLOCK),
                timeout=1000, block=False, block_timeout=5,
                )
        def _wrapper(*args, **kwargs):
            return func(*args, **kwargs)

        return _wrapper

    if isinstance(func_or_name, collections.abc.Callable):
        return _wrap_func(func_or_name)

    else:
        def _func_wrapper(func):
            return _wrap_func(func, func_or_name)
        return _func_wrapper


class FormsCeleryTask(CtxAwareMixin, Task):
    _execution_threshold = 0

    def __call__(self, *args, **kwargs):
        with log_context(delivery_info=self.request.delivery_info):
            return super(FormsCeleryTask, self).__call__(*args, **kwargs)


app = Celery('forms', task_cls=FormsCeleryTask)
app.config_from_object('django.conf:settings', namespace='CELERY')
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)
