# -*- coding: utf-8 -*-
from django.contrib.contenttypes.models import ContentType

from rest_framework import serializers
from events.rest_framework_contrib.serializers import (
    InternalModelSerializerV2Mixin,
)
from events.common_app.models import UserMessage
from events.media.api_admin.v2.serializers import ImageSerializer
from events.surveyme.models import Survey
from events.rest_framework_contrib.mixins import TranslationSerializerMixin


class ContentTypeSerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    class Meta:
        model = ContentType
        fields = (
            'id',
            'name',
            'app_label',
            'model'
        )


class SurveySerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    class Meta:
        model = Survey
        fields = (
            'id',
            'name',
        )


class UserMessageSerializer(TranslationSerializerMixin, InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    image = ImageSerializer(required=False, allow_null=True)

    class Meta:
        model = UserMessage
        fields = (
            'id',
            'name',
            'text',
            'link',
            'slug',
            'label',
            'show_count',
            'image',
        )


class CommaSeparatedField(serializers.Field):
    def to_internal_value(self, data):
        if isinstance(data, str):
            return [
                it
                for it in data.split(',')
                if it
            ]


class DirectorySuggestSerializer(serializers.Serializer):
    org_id = serializers.CharField()
    text = serializers.CharField(required=False)
    id = CommaSeparatedField(required=False)
    layers = CommaSeparatedField(required=False)
