# -*- coding: utf-8 -*-

from django.apps import AppConfig
from django.db.models.signals import pre_delete, post_migrate


class CommonAppConfig(AppConfig):
    name = 'events.common_app'

    def ready(self):
        from django.contrib.auth.models import Group
        from events.common_app.signals import (
            pre_delete_group,
            update_permissions_after_migration,
            add_full_permissions,
            update_contenttypes_names,
        )

        pre_delete.connect(pre_delete_group, sender=Group)
        post_migrate.connect(update_permissions_after_migration, sender=self)
        post_migrate.connect(add_full_permissions, sender=self)
        post_migrate.connect(update_contenttypes_names)
