# -*- coding: utf-8 -*-
from django.conf import settings
from events.common_app.utils import requests_session


class BaseClient:
    results_key = 'results'

    def get_params(self):
        return {}

    def get_headers(self):
        return {}

    def get_auth(self):
        return None

    def get_url(self):
        raise NotImplementedError

    def get_next_url(self, data):
        return data.get('next')

    def process_one_item(self, item):
        yield item

    def process_all_items(self, data):
        for item in data.get(self.results_key, []):
            yield from self.process_one_item(item)

    def make_request(self):
        url = self.get_url()
        params = self.get_params()
        while url:
            response = requests_session.get(
                url=url,
                params=params,
                headers=self.get_headers(),
                auth=self.get_auth(),
                allow_redirects=False,
                timeout=settings.DEFAULT_TIMEOUT,
                verify=settings.YANDEX_ROOT_CERTIFICATE,
            )
            response.raise_for_status()
            data = response.json()
            yield from self.process_all_items(data)
            url = self.get_next_url(data)
            params = None
