# -*- coding: utf-8 -*-
from django.conf import settings
from django.db.models import Q

from events.common_app.utils import add_model_prefix as add


class PublishedConditions(object):
    @classmethod
    def is_for_current_site_type(cls, model_instance=None, prefix=None):
        IS_INTERNAL_SITE = getattr(settings, 'IS_INTERNAL_SITE')

        if model_instance:
            if IS_INTERNAL_SITE:
                return model_instance.is_published_internal
            else:
                return model_instance.is_published_external
        else:
            if IS_INTERNAL_SITE:
                condition = Q(**{add(prefix, to='is_published_internal'): True})
            else:
                condition = Q(**{add(prefix, to='is_published_external'): True})

        return condition


def not_(instance_or_q_object):
    # todo: test me
    if isinstance(instance_or_q_object, bool):
        return not instance_or_q_object
    else:
        return ~instance_or_q_object


def and_(value_one_lambda, value_two_lambda):
    # todo: test me
    value_one = value_one_lambda()
    if isinstance(value_one, bool):
        return value_one and value_two_lambda()
    else:
        return value_one & value_two_lambda()


def or_(value_one_lambda, value_two_lambda):
    # todo: test me
    value_one = value_one_lambda()
    if isinstance(value_one, bool):
        return value_one or value_two_lambda()
    else:
        return value_one | value_two_lambda()


# class unbit_bool(object):
#     def __init__(self, lambda_bool):
#         self.lambda_bool_value = lambda_bool()
#
#     def __bool__(self):
#         return bool(self.lambda_bool_value)
#
#     def __nonzero__(self):
#         return type(self).__bool__(self)
#
#     def __and__(self, other_lambda_bool):
#         return self.lambda_bool_value and other_lambda_bool()
#
#     def __or__(self, other_lambda_bool):
#         return self.lambda_bool_value or other_lambda_bool()
