# -*- coding: utf-8 -*-
import logging
import urllib.parse

from django.conf import settings

from requests.auth import HTTPBasicAuth

from events.common_app.utils import requests_session


logger = logging.getLogger(__name__)


class DiskAdminAPIClient(object):
    def get_carma(self, uid):
        response_content = self._user_carma(uid)

        if not response_content.get('ok'):
            return '{%s}' % response_content.get('error', 'Unknown error')
        else:
            return response_content.get('carma', {}).get('user_carma', '{Unknown error}')

    def is_paid(self, uid):
        response_content = self._user_carma(uid)

        if not response_content.get('ok'):
            return '{%s}' % response_content.get('error', 'Unknown error')
        else:
            return response_content.get('user', {}).get('is_paid', '{Unknown error}')

    def is_paid_ps_billing(self, uid):
        response_content = self._user_carma(uid)

        if not response_content.get('ok'):
            return '{%s}' % response_content.get('error', 'Unknown error')
        else:
            return response_content.get('user', {}).get('is_paid_ps_billing', '{Unknown error}')

    def _user_carma(self, uid):
        params = {
            'uid': uid,
        }
        return self._make_request(
            urllib.parse.urljoin(settings.DISK_ADMIN_API_URL, 'user_carma'),
            params=params,
        )

    def _make_request(self, url, params):
        response = requests_session.get(
            url,
            auth=HTTPBasicAuth(settings.DISK_ADMIN_API_LOGIN, settings.DISK_ADMIN_API_PASSWORD),
            params=params,
            timeout=settings.DISK_ADMIN_TIMEOUT,
            verify=False,
        )

        logger.info(
            'url=%s params=%s response_status=%s response=%s',
            url,
            params,
            response.status_code,
            response.content,
        )
        return response.json()
