# -*- coding: utf-8 -*-
from threading import local

from unittest.mock import patch, Mock

from events.common_app.disk_admin.api_client import DiskAdminAPIClient


DISK_ADMIN_API_DATA = local()


def clear_disk_admin_api_data():
    DISK_ADMIN_API_DATA.valid_uids = []
    DISK_ADMIN_API_DATA.invalid_uids = []


VALID_DATA = {
    "ok": True,
    "carma": {
        "help": [
            {
                "name": "Registration date",
                "weight": 1,
                "description": "Registered more than a month ago"
            },
            {
                "name": "Yandex staff",
                "weight": 5,
                "description": "Flag \"yandex_staff\" == True"
            },
            {
                "name": "Use shared folders",
                "weight": 1,
                "description": "Owned: >0 or Joined: >0"
            },
            {
                "name": "Use photostream",
                "weight": 1,
                "description": "Have system directory \"photostream\""
            }
        ],
        "user_carma": 8
    },
    "user": {
        "is_b2b": False,
        "is_paid": True,
        "is_paid_ps_billing": True,
    }
}

INVALID_DATA = {
    "ok": False,
    "error": "User not initialized"
}


mocked_requests = Mock()


class DiskAdminMockClient(DiskAdminAPIClient):
    def get_carma(self, uid):
        if uid in DISK_ADMIN_API_DATA.valid_uids:
            return VALID_DATA['carma']['user_carma']
        else:
            return '{%s}' % INVALID_DATA['error']

    def is_paid(self, uid):
        if uid in DISK_ADMIN_API_DATA.valid_uids:
            return VALID_DATA['user']['is_paid']
        else:
            return '{%s}' % INVALID_DATA['error']

    def is_paid_ps_billing(self, uid):
        if uid in DISK_ADMIN_API_DATA.valid_uids:
            return VALID_DATA['user']['is_paid']
        else:
            return '{%s}' % INVALID_DATA['error']

    @patch('events.common_app.disk_admin.api_client.requests_session', mocked_requests)
    def _make_request(self, url, params):
        return super(DiskAdminMockClient, self)._make_request(url, params)
