# -*- coding: utf-8 -*-


import yt.wrapper


def get_yt_table_data(table, search_params=None, sort_by=None):
    if sort_by:
        yt.wrapper.run_sort(table, sort_by=[sort_by])
    if not search_params:
        search_params = {}
    return yt.wrapper.read_table(
        yt.wrapper.TablePath(
            table,
            **search_params
        ),
        yt.wrapper.JsonFormat(), raw=True
    )


def write_to_yt_table(table, data, append=True):
    yt.wrapper.write_table(
        yt.wrapper.TablePath(table, append=append),
        data,
    )
