# -*- coding: utf-8 -*-
import celery

from django.core.management import BaseCommand


class Command(BaseCommand):
    help = """Удаляет завершенные таски. Время, после которого завершенный таск
    будет попадать под удаление задается в CELERY_TASK_RESULT_EXPIRES"""

    def handle(self, *args, **options):
        clean_task = celery.task.backend_cleanup.delay()
        clean_task.wait(timeout=20)
        print(clean_task.state)
