# -*- coding: utf-8 -*-
import logging

import xml.etree.ElementTree
from django.conf import settings
from requests import RequestException

from events.common_app.utils import requests_session

logger = logging.getLogger(__name__)

MAPS_BASES = (
    'street', 'district',
    'locality', 'province',
    'house',
)


def get_maps_suggest(text):
    suggest_data = []
    try:
        response = make_maps_request(text)
    except RequestException:
        logger.exception('Got exception while getting info from maps api')
        return suggest_data
    try:
        response_xml = xml.etree.ElementTree.fromstring(response.content)
    except xml.etree.ElementTree.ParseError:
        logger.exception('Got exception while parsing maps api response')
        return suggest_data

    for item in response_xml.iter('item'):
        if item.attrib['lat'] != '0.0000':  # https://st.yandex-team.ru/FORMS-3409#5c9a36e553d9d00022bc4fcb
            display_text = item.find('.//display/t')
            if display_text is not None:
                suggest_data.append(display_text.text)
    return suggest_data


def make_maps_request(text):
    params = {
        'highlight': 0,
        'short_names': 0,
        'fullpath': 1,
        'reverse_geo_name': 1,
        'bases': ','.join(MAPS_BASES),
        'n': 10,
        'part': text,
    }
    response = requests_session.get(
        url=settings.MAPS_API_URL,
        params=params,
        timeout=settings.DEFAULT_TIMEOUT,
    )
    response.raise_for_status()
    return response
