# -*- coding: utf-8 -*-
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('common_app', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='PermissionLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('role_name', models.CharField(
                    choices=[
                        ('superuser', 'superuser'),
                        ('support', 'support'),
                        ('change_survey', 'form manager'),
                        ('change_surveygroup', 'group manager')
                    ],
                    max_length=24)),
                ('change_type', models.CharField(choices=[('assign', 'assign'), ('remove', 'remove')], max_length=8)),
                ('object_pk', models.CharField(max_length=24, null=True)),
                ('request_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, related_name='+')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, null=True, to=settings.AUTH_USER_MODEL, related_name='+')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, null=True, to='auth.Group', related_name='+')),
            ],
        ),
    ]
