# -*- coding: utf-8 -*-
from django.conf import settings
from django.db import migrations


def create_permissions(apps, schema_editor):
    Permission = apps.get_model('auth', 'Permission')
    ContentType = apps.get_model('contenttypes', 'ContentType')
    Survey = apps.get_model('surveyme', 'Survey')
    SurveyGroup = apps.get_model('surveyme', 'SurveyGroup')

    Permission.objects.create(
        name=settings.ROLE_FORM_FILEDOWNLOAD,
        codename=settings.ROLE_FORM_FILEDOWNLOAD,
        content_type=ContentType.objects.get_for_model(Survey),
    )

    Permission.objects.create(
        name=settings.ROLE_GROUP_FILEDOWNLOAD,
        codename=settings.ROLE_GROUP_FILEDOWNLOAD,
        content_type=ContentType.objects.get_for_model(SurveyGroup),
    )


class Migration(migrations.Migration):

    dependencies = [
        ('common_app', '0002_forms-7890'),
    ]

    operations = [
        migrations.RunPython(create_permissions, migrations.RunPython.noop),
    ]
