# -*- coding: utf-8 -*-
import logging

from django.conf import settings

from events.common_app.utils import requests_session

logger = logging.getLogger(__name__)


class MusicStatusClient(object):
    def __init__(self, url=settings.MUSIC_STATUS_URL):
        self.url = url

    def get_data(self, uid):
        response = requests_session.get(
            url=self.url,
            params={'__uid': uid},
            timeout=settings.MUSIC_STATUS_TIMEOUT,
        )
        if response.status_code == 200:
            return response.json()
        logger.warning('MusicStatusClient (%s) %s', response.status_code, response.content)

    def get_status(self, uid):
        data = self.get_data(uid) or {}
        return data.get('result', {}).get('status')
