# -*- coding: utf-8 -*-
import uuid

from django_tools_log_context.provider.base import BaseProvider


class Provider(BaseProvider):
    required_kwargs = ['request']

    def request(self, request):
        return {
            'id': self._get_request_id(request),
            'method': request.method,
            'path': request.path,
        }

    def _get_request_id(self, request):
        request_id = request.GET.get('request_id')
        if request_id:
            return request_id

        request_id = request.META.get('HTTP_X_ACTIVITY_ID')
        if request_id:
            return request_id

        return f'auto-{uuid.uuid4().hex}'
