# -*- coding: utf-8 -*-
import logging

from django.conf import settings

from events.common_app.utils import requests_session


logger = logging.getLogger(__name__)


class SupportAPIClient(object):
    API_HANDLE_MAP = {
        'referer': ('v1', 'visits', ),
    }

    def get(self, what, params=None, timeout=None):
        return self.make_request(
            what=what,
            params=params,
            timeout=timeout,

        ).json()

    def make_request(self, what, params, timeout=None):
        api_version, handle = self.API_HANDLE_MAP[what]
        url = '{base_url}/{api_version}/{handle}'.format(base_url=settings.SUPPORT_API_URL,
                                                         api_version=api_version,
                                                         handle=handle,
                                                         )
        response = requests_session.get(
            url=url,
            params=params,
            timeout=timeout or settings.DEFAULT_TIMEOUT,
            verify=settings.YANDEX_ROOT_CERTIFICATE,
            )
        logger.info('request_url=%s request_params=%s request_timeout=%s response_status=%s response=%s',
                    url,
                    params,
                    timeout,
                    response.status_code,
                    response.content,
                    )
        response.raise_for_status()
        return response
